/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_vars.h"


void UdmVarFree(UDM_VAR *S){
	UDM_FREE(S->name);
	UDM_FREE(S->val);
	return;
}

int UdmVarListAdd(UDM_VARLIST * Lst,UDM_VAR * S){
	Lst->Var=(UDM_VAR*)realloc(Lst->Var,(Lst->nvars+1)*sizeof(*Lst->Var));
	bzero(&Lst->Var[Lst->nvars],sizeof(*Lst->Var));
	Lst->Var[Lst->nvars].section=S->section;
	Lst->Var[Lst->nvars].maxlen=S->maxlen;
	Lst->Var[Lst->nvars].curlen=S->curlen;
	Lst->Var[Lst->nvars].name=strdup(S->name);
	Lst->Var[Lst->nvars].val=S->val?strdup(S->val):NULL;
	Lst->nvars++;
	return UDM_OK;
}


UDM_VAR * UdmVarListFind(UDM_VARLIST * vars,const char * name){
	int i;
	
	for(i=0;i<vars->nvars;i++)
		if(!strcasecmp(name,vars->Var[i].name))
			return(&vars->Var[i]);
	return(NULL);
}

const char *UdmVarListFindStr(UDM_VARLIST * vars,const char * name,const char * defval){
	UDM_VAR * var;
	if((var=UdmVarListFind(vars,name)) != NULL)
		return((var->val != NULL)?var->val:defval);
	else
		return(defval);
}

void UdmVarListInit(UDM_VARLIST *l){
	bzero(l,sizeof(*l));
}


void UdmVarListFree(UDM_VARLIST * vars){
	int i;
	for(i=0;i<vars->nvars;i++){
		UDM_FREE(vars->Var[i].name);
		UDM_FREE(vars->Var[i].val);
	}
	UDM_FREE(vars->Var);
	vars->nvars = 0;
}

int UdmVarListAddStr(UDM_VARLIST * vars,const char * name, const char * val){
	vars->Var=(UDM_VAR *)realloc(vars->Var,(vars->nvars+1)*sizeof(UDM_VAR));
	vars->Var[vars->nvars].section=0;
	vars->Var[vars->nvars].maxlen=0;
	vars->Var[vars->nvars].curlen=0;	
	vars->Var[vars->nvars].name=name?strdup(name):NULL;
	vars->Var[vars->nvars].val=val?strdup(val):NULL;
	vars->nvars++;
	return vars->nvars;
}

int UdmVarListAddInt(UDM_VARLIST * vars,const char * name, int val){
	char num[64];
	sprintf(num,"%d",val);
	return UdmVarListAddStr(vars,name,num);
}

int UdmVarListReplaceStr(UDM_VARLIST * vars,const char * name,const char * val){
	UDM_VAR * var;
	
	if((var=UdmVarListFind(vars,name)) != NULL) {
		if(var->val != NULL) free(var->val);
		var->val=(val != NULL)?strdup(val):NULL;
		var->section=0;
		var->maxlen=0;
		var->curlen=0;
	}else{
		UdmVarListAddStr(vars,name,val);
	}
	return vars->nvars;
}

int UdmVarListReplaceInt(UDM_VARLIST * vars,const char * name,int val){
	UDM_VAR * var;
	char num[64];
	sprintf(num,"%d",val);
	if((var=UdmVarListFind(vars,name)) != NULL){
		if(var->val != NULL) free(var->val);
		var->val=strdup(num);
		var->section=0;
		var->maxlen=0;
		var->curlen=0;
	}else{
		UdmVarListAddInt(vars,name,val);
	}
	return vars->nvars;
}


UDM_VAR * UdmVarListFindWithValue(UDM_VARLIST * vars,const char * name,const char * val){
	int i;
	
	for(i=0;i<vars->nvars;i++)
		if(!strcasecmp(name,vars->Var[i].name)&&!strcasecmp(val,vars->Var[i].val))
			return(&vars->Var[i]);
	return(NULL);
}

int UdmVarListFindInt(UDM_VARLIST * vars,const char * name,int defval){
	UDM_VAR * var;
	if((var=UdmVarListFind(vars,name)) != NULL)
		return((var->val != NULL)?atoi(var->val):defval);
	else
		return(defval);
}

int UdmVarListEnter(UDM_VARLIST *vars){
	if(vars->level<UDM_MAXVARLEVEL){
		vars->bottom[vars->level]=vars->nvars;
		vars->level++;
	}
	return UDM_OK;
}

int UdmVarListLeave(UDM_VARLIST *vars){
	if(vars->level>0){
		size_t i;
		size_t nvars=vars->nvars;
		
		vars->level--;
		vars->nvars=vars->bottom[vars->level];
		
		for(i=vars->nvars;i<nvars;i++){
			UDM_FREE(vars->Var[i].name);
			UDM_FREE(vars->Var[i].val);
		}
	}
	return UDM_OK;
}
